function test_suite = testSym %#ok<*STOUT>
initTestSuite;

function d = setup
d = digits; % Store digits setting at time of call
digits(32)

function testSingleChar(~) %#ok<*DEFNU>
x = polysym('x');
y = sym(x);
% This funny syntax ensures compatibility between R2012b and later
% versions of MATLAB
assertTrue(logical(y==sym('x'))) 

function testCharArray(~)
x = polysym('x',2);
y = sym(x);
tf = y==sym('x',2);     % For some reason, isequal doesn't work here.
assertTrue(all(tf(:)))

function testZero(~)
x = polysym(sym(0));
assertEqual(x.Value,char(vpa(0)))

function testVpa(~)
y = vpa(pi);
x = polysym(y);
yy = sym(x);
assertTrue(abs(double(y-yy))<10^(-digits+1))

function testDouble(~)
r = randn(2);
x = polysym(r);
y = sym(x);
assertElementsAlmostEqual(r,double(y),'absolute',eps*100)

function testImaginary(~)
r = randn(2)*1i;
x = polysym(r);
y = sym(x);
assertElementsAlmostEqual(r,double(y),'absolute',eps*100)

function testComplex(~)
r = exp(1i*randn(2));
x = polysym(r);
y = sym(x);
assertElementsAlmostEqual(r,double(y),'absolute',eps*100)

function testString(~)
% For strings, the two results should be exactly equal.
str = '3.14159265358979323846264338328';
x = polysym(str);
y = sym(x);
assertEqual(cellstr(x),{char(y)})

function teardown(d)
digits(d)
